<?php

namespace App\Http\Requests\Lecture;

use App\Http\Requests\FormRequest;

class CreateLectureRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'name'               => ['required', 'string', 'max:255'],
            'url'                => ['nullable', 'url', 'max:255'],
            'start_time'         => ['required', 'date'],
            'week_number'        => ['nullable', 'integer', 'min:1'],
            'round_id'           => ['required', 'exists:rounds,id'],
            'meeting_start_time' => ['nullable', 'date', 'date_format:Y-m-d H:i:s','after_or_equal:now'],
            'meeting_duration'   => ['nullable', 'integer', 'min:1'],
            'files' => ['nullable', 'array'],
            'files.*' => ['file', 'mimes:pdf'],
        ];
    }
}
