<?php

namespace App\Http\Requests\LectureTask;

use Carbon\Carbon;
use App\Models\Lecture;
use Illuminate\Foundation\Http\FormRequest;

class UpdateLectureTaskRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'lecture_id'       => ['required','exists:lectures,id'],
            'description'      => ['required','string'],
            'goal'             => ['nullable','string'],
            'note'             => ['nullable','string'],
            'files_included'   =>['nullable','file','mimes:pdf,doc,docx,xls,xlsx,ppt,pptx,zip,rar,img,png,bmp,jpeg,jpg,json'],
            // 'files_included'   => ['nullable','array'],
            // 'files_included.*' => ['nullable','file','mimes:pdf,doc,docx,xls,xlsx,ppt,pptx,zip,rar,img,png,bmp,jpeg,jpg,json'],
            'deadline'         => ['nullable','date'],
            'task_link'        => ['nullable','string','url'],
        ];
    }
    public function validated($key = null, $default = null)
    {
        $data = parent::validated();

        if ($this->input('deadline')) {
            $data['deadline'] = Carbon::parse($this->input('deadline'))->format('Y-m-d H:i:s');
        } else {
            $data['deadline'] = Carbon::parse(Lecture::find($data['lecture_id'])->start_at)->addDays(7)->format('Y-m-d H:i:s');
        }
        return $data;
    }
}
