<?php

namespace App\Http\Requests\Round;

use App\Models\Course;
use App\Http\Requests\FormRequest;

class UpdateRoundRequest extends FormRequest
{
    public function rules(): array
    {
        return array_merge((new CreateRoundRequest())->rules(), [
        ]);
    }
    public function validated($key = null, $default = null){
        $dataValidated          = parent::validated();
        if (!isset($dataValidated['price'])) {
            $dataValidated['price'] = Course::where('id', $dataValidated['course_id'])->value('price');
        }
        if (isset($dataValidated['discount']) && $dataValidated['price']) {
            $dataValidated['price'] = $dataValidated['price'] - $dataValidated['discount'];
        }
        return $dataValidated;
    }
}
