<?php

namespace App\Http\Requests\RoundSupervisor;

use App\Enums\UserType;
use App\Http\Requests\FormRequest;

class AddSupervisorRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'round_id' => ['required', 'integer', 'exists:rounds,id'],
            'user_ids' => ['required', 'array', 'exists:users,id,type,' . UserType::SUPERVISOR->value],
        ];
    }
}
