<?php

namespace App\Http\Requests\Setting;

use App\Models\Setting;
use Illuminate\Foundation\Http\FormRequest;

class UpdateSettingRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'logo' => ['nullable', 'image', 'mimes:png,jpg,jpeg,webp', 'max:2048'],
            'logo_student' => ['nullable', 'image', 'mimes:png,jpg,jpeg,webp', 'max:2048'],
            'logo_instructor' => ['nullable', 'image', 'mimes:png,jpg,jpeg,webp', 'max:2048'],

            'facebook'   => ['nullable', 'url'],
            'linkedin'   => ['nullable', 'url'],
            'x'          => ['nullable', 'url'],
            'telegram'   => ['nullable', 'url'],
            'youtube'    => ['nullable', 'url'],
            'instagram'  => ['nullable', 'url'],
            'tiktok'     => ['nullable', 'url'],

            'phone_1'         => ['nullable', 'string', 'max:20'],
            'phone_2'         => ['nullable', 'string', 'max:20'],
            'whatsapp_num_1'  => ['nullable', 'string', 'max:20'],
            'whatsapp_num_2'  => ['nullable', 'string', 'max:20'],

            'about'                 => ['nullable', 'string'],
            'help_center'           => ['nullable', 'string'],
            'terms_and_conditions'  => ['nullable', 'string'],
            'about_ar'              => ['nullable', 'string'],
            'help_center_ar'        => ['nullable', 'string'],
            'terms_and_conditions_ar' => ['nullable', 'string'],

            'refund_policy'       => ['nullable', 'string'],
            'refund_policy_ar'    => ['nullable', 'string'],
            'privacy_policy'      => ['nullable', 'string'],
            'privacy_policy_ar'   => ['nullable', 'string'],

            'listening'     => ['nullable', 'numeric', 'min:0'],
            'reading'       => ['nullable', 'numeric', 'min:0'],
            'case'          => ['nullable', 'numeric', 'min:0'],
            'time_of_exam'  => ['nullable', 'numeric', 'min:1'],

            'primary_color'   => ['nullable'],
            'secondary_color' => ['nullable'],
            'third_color'     => ['nullable'],
            'start_link' =>['nullable','url'],
            'instapy'=> ['nullable','string'],
        ];
    }

    public function withValidator($validator)
    {
        $validator->after(function ($validator) {
            foreach ($this->all() as $key => $value) {
                if (!Setting::where('key', $key)->exists()) {
                    $validator->errors()->add($key, "The key '{$key}' does not exist in the settings.");
                }
            }
        });
    }
}
