<?php

namespace App\Http\Requests\Transaction;

use App\Enums\PaymentStatus;
use Illuminate\Validation\Rule;
use App\Http\Requests\FormRequest;

class StoreStudentTransactionRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'total_amount'                  => ['nullable', 'numeric', 'min:0'],
            'installments'                  => ['required', 'array'],
            'installments.*.due_date'       => ['required', 'date'],
            'installments.*.amount'         => ['required', 'numeric', 'min:0'],
            'installments.*.payment_status' => ['required', 'integer', Rule::in(PaymentStatus::values())],
        ];
    }
}
