<?php

namespace App\Http\Requests\User;

use App\Enums\DefineStatus;
use App\Enums\UserGender;
use Illuminate\Validation\Rule;
use App\Http\Requests\FormRequest;
use App\Http\Requests\User\CreateUserRequest;

class UpdateUserRequest extends FormRequest
{

    public function rules(): array
    {
        // Fetch the bound user based on the route.
        $user = $this->route('instructor')
            ?? $this->route('student')
            ?? $this->route('supervisor')
            ?? $this->route('admin');

        $userId = $user?->id;

        return [
            'name'     => ['nullable', 'string', 'max:255'],
            'email'    => ['nullable', 'string', 'email', 'max:255', Rule::unique('users', 'email')->ignore($userId)],
            'phone'    => ['nullable', 'string', 'max:20', Rule::unique('users', 'phone')->ignore($userId)],
            'photo'    => ['nullable', 'image', 'mimes:jpeg,png,jpg,webp', 'max:2048'],
            // 'title'    => ['nullable', 'string', 'max:255'],
            'password' => ['nullable', 'string', 'min:8', 'max:255', 'confirmed'],
            'status'   => ['nullable', 'integer', Rule::in(DefineStatus::values())],
            'placement_test_status'=>['nullable', 'integer', Rule::in(DefineStatus::values())],
            'country'  => ['nullable', 'string', 'max:255'],
            'gov'      => ['nullable', 'string', 'max:255'],
            'college'  => ['nullable', 'string', 'max:255'],
            'birthdate'=>['nullable', 'date', 'max:255'],
            'role_id'=>['nullable', 'integer','exists:roles,id'],
            'gender' => ['nullable', 'integer', Rule::in(UserGender::values())],
            'desc_instructor'=>['nullable', 'string', 'max:500000'],
            'assign_round'=>['nullable', 'array'],
            'skills_status'=>['nullable', 'boolean'],
        ];
    }
}
