<?php

namespace App\Http\Resources\Coupon;

use Illuminate\Http\Resources\Json\JsonResource;

class CouponResource extends JsonResource
{
    public function toArray($request): array
    {
        return [
            'id'                  => $this->id,
            'code'                => $this->code,
            'type'                => $this->type,
            'discount_percentage' => $this->discount_percentage,
            'max_uses'            => $this->max_uses,
            'uses'                => $this->uses,
            'start_date'          => $this->start_date,
            'end_date'            => $this->end_date,
            'status'              => $this->status,
            'created_at'          => dateTimeFormat($this->created_at),
            'updated_at'          => dateTimeFormat($this->updated_at),
        ];
    }
}
