<?php
namespace App\Http\Resources\CourseEnrollment;

use App\Http\Resources\Installment\InstallmentResource;
use App\Http\Resources\PaymentMethod\PaymentMethodResources;
use App\Http\Resources\Transaction\TransactionResource;
use App\Models\Installment;
use App\Models\Transaction;
use Illuminate\Http\Resources\Json\JsonResource;

class CourseEnrollmentResource extends JsonResource
{
    public function toArray($request): array
    {
        return [
            'id'               => $this->id,
            'course_name'      => $this->whenLoaded('course', fn () => $this->course->title ?? null),
            'user'             => $this->whenLoaded('user', fn () => $this->user->name ?? $this->user->phone ?? null),
            'transactions' => TransactionResource::collection(
                $this->whenLoaded('transactions')
            ),
            'total_amount'     => $this->total_amount ?? 0,
            'enrollment_date'  => $this->enrollment_date ?? null,
            'status'           => $this->status ?? false,
            'payment_method'   => $this->payment_method ?? null,
            'payment_status'   => is_object($this->payment_status)
                ? [
                    'value' => $this->payment_status->value,
                    'label' => $this->payment_status->name
                ]
                : $this->payment_status,

            'course_id'        => $this->course_id ?? null,
            'user_id'          => $this->user_id ?? null,
            'round_id'         => $this->round_id ?? null,
            'coupon_id'        => $this->coupon_id ?? null,
            'coupon_amount'    => $this->coupon_amount ?? 0,
            'payment_type'     => is_object($this->payment_type)
                ? [
                    'value' => $this->payment_type->value,
                    'label' => $this->payment_type->name
                ]
                : $this->payment_type,
            'installments'=>$this->whenLoaded('installments',function(){
                return InstallmentResource::collection($this->installments);
            }),
            'transaction_id'   => $this->transaction_id ?? null,
            'paid'             => $this->paid ?? null,
            'fawry_ref'        => $this->fawry_ref ?? null,
            'fawry_response'   => $this->fawry_response ?? null,
            'created_by'       => $this->created_by ?? null,
            'updated_by'       => $this->updated_by ?? null,
            'created_at'       => $this->created_at?->toDateTimeString(),
            'updated_at'       => $this->updated_at?->toDateTimeString(),
        ];
    }
}

