<?php

namespace App\Http\Resources\Enrollment;

use App\Http\Resources\Round\RoundResource;
use App\Http\Resources\User\UserResource;
use Illuminate\Http\Resources\Json\JsonResource;

class EnrollmentResource extends JsonResource
{
    public function toArray($request): array
    {
        return [
            'student' => new UserResource($this->whenLoaded('user')),
            'round'   => new RoundResource($this->whenLoaded('round')),
        ];
    }
}
