<?php

namespace App\Http\Resources\Expense;

use App\Http\Resources\User\UserResource;
use App\Http\Resources\Lecture\LectureResource;
use App\Http\Traits\ResourceHelper;
use Illuminate\Http\Resources\Json\JsonResource;

class ExpenseResource extends JsonResource
{
    use ResourceHelper;

    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'expense_category_id' => $this->whenExists($this->expense_category_id),
            'expense_category' => $this->whenLoaded('expenseCategory'),
            'payment_method_id' => $this->whenExists($this->payment_method_id),
            'payment_method' => $this->whenLoaded('paymentMethod'),
            'bio' => $this->whenExists($this->bio),
            'cost' => $this->whenExists($this->cost),
            'accepted_by' => new UserResource($this->whenLoaded('acceptedBy')),
            'morphable_type' => $this->whenExists($this->morphable_type),
            'morphable_id' => $this->whenExists($this->morphable_id),
            'created_by' => new UserResource($this->whenLoaded('createdBy')),
            'updated_by' => new UserResource($this->whenLoaded('updatedBy')),
            'created_at' => $this->created_at?->toDateTimeString(),
            'updated_at' => $this->updated_at?->toDateTimeString(),
        ];
    }

}
