<?php

namespace App\Http\Resources\Lecture;
use App\Http\Resources\Attachment\AttachmentResource;
use App\Http\Resources\Evaluation\EvaluationResource;
use App\Http\Resources\LectureTask\LectureTaskResource;
use App\Http\Resources\Round\RoundResource;
use App\Http\Resources\TaskSubmission\TaskSubmissionResource;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\ZoomIntegration\ZoomIntegrationResource;

class LectureResource extends JsonResource
{
    public function toArray($request): array
    {
        return [
            'id'          => $this->id,
            'round_id'    => $this->round_id,
            'name'        => $this->name,
            'url'         => $this->url,
            'start_time'  => $this->start_time,
            'week_number' => $this->week_number,
            'status'      => $this->status,
            'task_submissions_is_corrected' => $this->whenLoaded('round', function () {
                return $this->taskSubmissionsIsCorrected();
            }),
            'lecture_videos'=>lectureVideosResource::collection($this->whenLoaded('lectureVideos')),
            'round'       => new RoundResource($this->whenLoaded('round')),
            'zoom_meetings' => ZoomIntegrationResource::make($this->whenLoaded('zoomMeetings')),
            'files'=>AttachmentResource::collection($this->whenLoaded('attachments')),
            'link'                     => $this->link,
            'record_link'              => $this->record_link,
            'start_at'                 => $this->start_at,
            'lecture_task' => $this->whenLoaded('lectureTasks', function () {
                return new LectureTaskResource($this->lectureTasks);
            }),
            // 'students_tasks_submitted' => $this->whenLoaded('taskSubmissions', function () {
            //     return TaskSubmissionResource::collection($this->taskSubmissions);
            // }),
            'my_evaluation'            => $this->whenLoaded('studentEvaluation', function () {
                return EvaluationResource::make($this->studentEvaluation);
            }),
            'my_task_submission'       => $this->whenLoaded('studentTaskSubmission', function () {
                return TaskSubmissionResource::make($this->studentTaskSubmission);
            }),
            'created_at'               => $this->created_at ?? dateTimeFormat($this->created_at),
        ];
    }
}
