<?php

namespace App\Http\Resources\LectureQuestionClientSide;

use App\Enums\QuestionType;
use App\Http\Resources\LectureQuestionCase\LectureQuestionCaseResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class QuestionResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id'=>$this->id,
            'lecture_id'       => $this->lecture_id,
            'question_type'=>$this->question_type,
            'question_content'=>$this->getQuestionContent(),
            'listening_content'=>$this->getUrlAttribute(),
            'answer_writing'=>$this->answer_writing,
            'tag'              => $this->whenLoaded('tag'),
            'options'=>QuestionOptionResource::collection($this->whenLoaded('options')),
            'case'=> new LectureQuestionCaseResource($this->whenLoaded('case')),
        ];
    }
}
