<?php

namespace App\Http\Resources\Notice;

use App\Http\Resources\Round\RoundResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class NoticeResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id'=>$this->id,
            'content'=>$this->content,
            'type'=>$this->type,
            'read'=>$this->read,
            'created_by'=>$this->created_by_user,
            'created_at'=>$this->created_at->format('Y-m-d H:i:s'),
            'round_id'=>new RoundResource($this->whenLoaded('round'))
        ];
    }
}
