<?php

namespace App\Http\Resources\NoticeAbsent;

use App\Http\Resources\Lecture\LectureResource;
use App\Http\Resources\User\UserResource;
use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class NoticeAbsentResource extends JsonResource
{
    public function toArray($request): array
    {
        return [
            'id'=> $this->id,
            'lecture'=>new LectureResource($this->whenLoaded('lecture')),
            'student'=>new UserResource($this->whenLoaded('student')),
            'content'=>$this->notice_absent,
            'type'=>$this->type,
            'read'=>$this->read,
            'created_at'=>$this->created_at->format('Y-m-d H:i:s'),
            'updated_at'=>$this->updated_at->format('Y-m-d H:i:s'),
            'created_by'=>$this->whenLoaded('createdBy'),
            'updated_by'=>$this->whenLoaded('updatedBy'),
        ];
    }
}
