<?php

namespace App\Http\Resources\PlacementTest;

use App\Enums\QuestionType;
use App\Http\Resources\LectureQuestionCase\LectureQuestionCaseResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Storage;

class QuestionResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id'=>$this->id,
            'question_type'=>$this->question_type,
            'question_content'=>$this->question_content,
            'listening_content'=>$this->getUrlAttribute(),
            'answer_writing'=>$this->answer_writing,
            'category'=>new CategoryResource($this->category),
            'tag'              => $this->whenLoaded('tag'),
            'options'=>BankOptionResource::collection($this->whenLoaded('options')),
            'case'             => $this->case,
        ];
    }
}
