<?php

namespace App\Http\Resources\RoundStudent;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\Round\RoundResource;
use App\Http\Resources\User\UserResource;
class RoundStudentResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id'              => $this->id,
            'round_id'        => RoundResource::make($this->whenLoaded('round')),
            'user_id'         => UserResource::make($this->whenLoaded('user')),
            'total_amount'    => $this->total_amount,
            'enrollment_date' => $this->enrollment_date,
            'status'          => $this->status,
            'payment_method'  => $this->payment_method,
            'payment_status'  => $this->payment_status,
            'transaction_id'  => $this->transaction_id,
        ];
    }
}
