<?php

namespace App\Http\Resources\RoundSupervisor;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class RoundSupervisorResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'round_name' => $this->name,
            'supervisors' => $this->supervisors->map(fn($supervisor) => [
                'id' => $supervisor->id,
                'name' => $supervisor->name,
            ]),
        ];
    }
}
