<?php

namespace App\Http\Resources\RoundSupervisor;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class SupervisorRoundResource extends JsonResource
{
      /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'supervisor_name' => $this->name,
            'rounds'          => $this->supervisorRounds->map(function ($round) {
                return [
                    'id'   => $round->id,
                    'name' => $round->name,
                ];
            }),
        ];
    }
}
