<?php

namespace App\Http\Resources\StudentHome;

use App\Http\Resources\Course\CourseResource;
use App\Http\Resources\Round\RoundResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProgressbarResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'total_progress' => $this->total_progress,
            'round' => [
                'id' => $this->id,
                'name' => $this->name,
            ],
            'course' => new CourseResource($this->whenLoaded('course')),
        ];
    }
}
