<?php

namespace App\Http\Resources\StudentHome;

use App\Http\Resources\ZoomIntegration\ZoomIntegrationResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class UpcomingMeetingResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'today_meetings' => ZoomIntegrationResource::collection($this['today_meetings']),
            'month_meetings' => ZoomIntegrationResource::collection($this['month_meetings'])
        ];
    }
}
