<?php

namespace App\Http\Resources\Subject;

use App\Http\Resources\FreeMaterial\FreeMaterialResource;
use Illuminate\Http\Resources\Json\JsonResource;

class SubjectResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'description' => $this->description,
            'free_materials'=> FreeMaterialResource::collection($this->whenLoaded('freeMaterial')),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
