<?php

namespace App\Http\Resources\TaskFeedback;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\Lecture\LectureResource;
class TaskFeedbackResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id'                 => $this->id,
            'task_submission_id' => $this->task_submission_id,
            'content'            => $this->content,
            'type'               => $this->type,
            'note'               => $this->note,
            'read'=>$this->read,
            'created_at'         =>$this->created_at->format('d/m/y h:i A'),
            'created_by'         =>$this->created_by_user,
            'user_name' => $this->whenLoaded('taskSubmission', function () {
                return $this->taskSubmission->user?->name;
            }),
            'lecture'            => new LectureResource($this->whenLoaded('lecture')),
        ];
    }
}
