<?php

namespace App\Http\Resources\Transaction;

use App\Models\Round;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\Enrollment\EnrollmentResource;
use App\Http\Resources\Installment\InstallmentResource;
use App\Http\Resources\PaymentMethod\PaymentMethodResources;
use App\Http\Resources\Round\RoundResource;
use App\Models\Payment;

class TransactionResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'reference_code'=>$this->reference_code,

            'payment_methods' => $this->whenLoaded('paymentMethod', function () {
                return new PaymentMethodResources($this->paymentMethod);
            }),

            'installment'=>$this->whenLoaded('installment', function () {
                return new InstallmentResource($this->installment);
            }),

            'user' => $this->whenLoaded('user', function () {
                return [
                    'id' => $this->user->id,
                    'name' => $this->user->name,
                ];
            }),


            'course_enrollment_id' => $this->course_enro_id,
            'installment_id' => $this->installment_id,

            'amount' => $this->amount,
            'payment_method' => $this->payment_method,

            'round' => $this->whenLoaded('courseEnrollment', function () {
                return new RoundResource($this->courseEnrollment->round);
            }),

            'course' => $this->when(
                $this->relationLoaded('courseEnrollment') &&
                optional($this->courseEnrollment)->relationLoaded('round') &&
                optional($this->courseEnrollment->round)->relationLoaded('course'),
                fn() => $this->courseEnrollment->round->course
            ),


            'type' => [
                'value' => $this->type->value,
                'label' => $this->type->name,
            ],

            'payment_date' => $this->payment_date?->toDateString(),
            'notes' => $this->notes,

            'accepted_by' => [
                'id' => $this->accepted_by,
                'name' => $this->accepted_by_user,
            ],


            'created_at' => $this->created_at?->toDateTimeString(),
            'updated_at' => $this->updated_at?->toDateTimeString(),
        ];
    }
    // public function toArray(Request $request): array
    // {
    //     return [
    //         'id'                             => $this->id,
    //         'total_amount'                   => $this->total_amount,
    //         'paid_amount'                    => $this->paid_amount,
    //         'remaining_amount'               => $this->remaining_amount,
    //         'status'                         => $this->status,
    //         'enrollment'                     => new EnrollmentResource($this->whenLoaded('enrollment')),
    //         'installments'                   => InstallmentResource::collection($this->whenLoaded('installments')),
    //         'has_unpaid_installment'         => $this->hasUnpaidInstallment(),
    //         'has_due_installment_this_month' => $this->hasDueInstallmentThisMonth(),
    //     ];
    // }
}
