<?php

namespace App\Http\Traits;

use Illuminate\Validation\ValidationException;


trait ApiResponse
{
    public static function apiResponse($data, $message = null, $status = 200)
    {
        $message = $message ? __($message) : ('Successful query');
        return response()->json([
            'message' => $message,
            'data'    => !empty($data) ? $data : null,
            'status'  => in_array($status, [200, 201, 202, 203]),
            'code'    => $status,
        ], $status);
    }

    public static function apiResponseStored($data)
    {
        return self::apiResponse($data, 'http-statuses.201', 201);
    }

    public static function apiResponseShow($data)
    {
        return self::apiResponse($data, 'main.success_query', 200);
    }

    public static function apiResponseFailed($text)
    {
        return self::apiResponse([], $text, 404);
    }

    public static function apiResponseUpdated($data)
    {
        return self::apiResponse($data, 'main.updated', 200);
    }
    public static function apiResponseDeleted()
    {
        return self::apiResponse([], 'main.deleted', 200);
    }
    public function failedValidation($validator)
    {
        $response =  self::apiResponse($validator->errors(), __('http-statuses.422'), 422);
        throw new ValidationException($validator, $response);
    }
}
