<?php

namespace App\Http\Traits;

use App\Enums\DefineStatus;
use App\Models\Lecture;
use App\Models\Round;
use App\Models\TaskSubmission;

use function PHPSTORM_META\type;

trait EnsuresInstructorAccess
{
        /**
     * Ensure the given round belongs to the authenticated instructor and is active.
     *
     * @param Round $round
     * @return void
     */
    private function ensureRoundAndInstructor(Round $round)
    {
        $instructorId = auth()->id();
        // $inArray=in_array($instructorId,$round->additional_instructors);
        // abort_if(($round->instructor_id != $instructorId || !$inArray) || $round->status !== DefineStatus::ACTIVE, 404);
    }

    /**
     * Ensure the given lecture belongs to the specified round and is active.
     *
     * This method first verifies the instructor's access to the round,
     * then ensures that the lecture is linked to the correct round and is active.
     *
     * @param Round $round
     * @param Lecture $lecture
     * @return void
     */
    private function ensureLectureBelongsToRound(Round $round, Lecture $lecture)
    {
        $this->ensureRoundAndInstructor($round);
        // abort_if($lecture->round_id !== $round->id || $lecture->status !== DefineStatus::ACTIVE, 404);
    }

    /**
     * Ensure the given task submission belongs to the specified lecture.
     *
     * This method first verifies the instructor's access to the round and the lecture,
     * then checks if the task is correctly linked to the lecture.
     *
     * @param Round $round
     * @param Lecture $lecture
     * @param TaskSubmission $task
     * @return void
     */
    private function ensureTaskBelongsToLecture(Round $round, Lecture $lecture, TaskSubmission $task = null)
    {
        $this->ensureLectureBelongsToRound($round, $lecture);
        // abort_if($task->lecture_id != $lecture->id, 404);
    }
}
