<?php

namespace App\Models;

use App\Filters\EvaluationFilters;
use Essa\APIToolKit\Filters\Filterable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;


class Evaluation extends Model
{
    use HasFactory, Filterable;

    protected string $default_filters = EvaluationFilters::class;

    /**
     * Mass-assignable attributes.
     *
     * @var array
     */
    protected $fillable = [
        'lecture_id',
        'user_id',
        'attendance_degree',
        'assignment_degree',
        'is_attend',
    ];

    /**
     * Relationship with user (as student)
     * each evaluation belongs to a user
     */
    public function student(): BelongsTo
    {
        return $this->belongsTo(User::class,'user_id');
    }

    /**
     * Relationship with lecture
     * each evaluation belongs to a lecture
     */
    public function lecture(): BelongsTo
    {
        return $this->belongsTo(Lecture::class);
    }
}
