<?php

namespace App\Models;

use App\Filters\FeedbackFilters;
use Essa\APIToolKit\Filters\Filterable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Feedback extends Model
{
    use HasFactory,Filterable;

    protected string $default_filters = FeedbackFilters::class;

    protected $table = 'feedbacks';
    protected $fillable = [
        'user_id',
        'course_id',
        'content',
        'rating',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function course()
    {
        return $this->belongsTo(Course::class);
    }

}
