<?php

namespace App\Models;

use App\Filters\InstallmentFilters;
use Illuminate\Database\Eloquent\Model;
use App\Enums\InstallmentStatusEnum;
use Essa\APIToolKit\Filters\Filterable;
use Illuminate\Support\Facades\Auth;

class Installment extends Model
{
    use Filterable;
    protected string $default_filters = InstallmentFilters::class;

    protected $fillable = [
        'user_id', 'course_enrollment_id', 'amount', 'due_date',
        'paid_at', 'status', 'notes', 'created_by', 'updated_by'
    ];

    protected $casts = [
        'status' => InstallmentStatusEnum::class,
        'paid_at' => 'date',
        'due_date' => 'date',
    ];

    public static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            if (Auth::check()) {
                $model->created_by = $model->created_by ?? Auth::id();
            }
        });

        static::updating(function ($model) {
            if (Auth::check()) {
                $model->updated_by = Auth::id();
            }
        });
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function courseEnrollment()
    {
        return $this->belongsTo(CourseEnrollment::class, 'course_enrollment_id');
    }

    public function transactions()
    {
        return $this->hasMany(Transaction::class, 'installment_id');
    }
}
