<?php

namespace App\Models;

use Essa\APIToolKit\Filters\Filterable;
use Illuminate\Database\Eloquent\Model;
use App\Filters\LectureQuestionCaseFilters;

class LectureQuestionCase extends Model
{
    use Filterable;
    protected string $default_filters = LectureQuestionCaseFilters::class;

    protected $table = 'lecture_question_cases';
    protected $fillable = [
        'lecture_id',
        'case',
    ];

    public function lecture()
    {
        return $this->belongsTo(Lecture::class);
    }

    public function lectureQuestions()
    {
        return $this->belongsToMany(LectureQuestion::class);
    }
}
