<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class LecturerLog extends Model
{
    protected $fillable = [
        'lecture_id',
        'user_id',
        'course_id',
        'action',
        'description',
    ];

    public function lecturer()
    {
        return $this->belongsTo(Lecture::class);
    }

    public function student()
    {
        return $this->belongsTo(User::class);
    }

    public function course()
    {
        return $this->belongsTo(Course::class);
    }
}
