<?php

namespace App\Models;

use App\Enums\FeedbackType;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;

class Notice extends Model
{
    protected $fillable = [
        'round_id',
        'content',
        'type',
        'note',
        'created_by',
        'updated_by',
        'read'
    ];

    protected $casts = [
        'type'=>FeedbackType::class,
    ];

    protected $appends = ['created_by_user'];

    public static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            if (Auth::check()) {
                $model->created_by = Auth::id();
                $model->updated_by = Auth::id();
            }
        });
    }

    public function round(){
        return $this->belongsTo(Round::class, 'round_id');
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function getCreatedByUserAttribute()
    {
        return $this->relationLoaded('createdBy') ? $this->createdBy?->name : null;
    }

    public function getContentAttribute($value)
    {
        if($this->type->value == FeedbackType::IMAGE->value || $this->type->value == FeedbackType::AUDIO->value){
            return asset(Storage::url($value));
        }
        return $value;
    }
}
