<?php

namespace App\Models;

use App\Enums\FeedbackType;
use App\Filters\NoticeAbsentFilters;
use Essa\APIToolKit\Filters\Filterable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;

class NoticeAbsent extends Model
{
    use Filterable;
    protected $default_filters = NoticeAbsentFilters::class;

    protected $casts = [
        'type' => FeedbackType::class,
    ];
    protected $fillable = [
        'lecture_id',
        'student_id',
        'notice_absent',
        'read',
        'created_by',
        'updated_by',
        'type',
    ];

    public function lecture()
    {
        return $this->belongsTo(Lecture::class);
    }

    public function student()
    {
        return $this->belongsTo(User::class);
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class);
    }

    public function updatedBy()
    {
        return $this->belongsTo(User::class);
    }

    public static function boot()
    {
        parent::boot();
        static::created(function ($noticeAbsent) {
            $noticeAbsent->createdBy()->associate(auth()->user());
        });
        static::updated(function ($noticeAbsent) {
            $noticeAbsent->updatedBy()->associate(auth()->user());
        });
    }

    public function getNoticeAbsentAttribute($value)
    {
        if(is_null($this->type)) {
            return $value;
        }
        if($this->type->value == FeedbackType::IMAGE->value || $this->type->value == FeedbackType::AUDIO->value){
            return asset(Storage::url($value));
        }
        return $value;
    }
}
