<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class NoticeStudent extends Model
{
    protected $fillable = [
        'user_id',
        'content',
        'created_by',
        'updated_by'
    ];
    public function user(){
        return $this->belongsTo(User::class);
    }
    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function updatedBy()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }

    public function getCreatorNameAttribute()
    {
        return $this->createdBy?->name ?? '—';
    }

    public function getUpdaterNameAttribute()
    {
        return $this->updatedBy?->name ?? '—';
    }


    public static function boot(){
        parent::boot();
        static::creating(function ($model) {
            $model->created_by = auth()->id();
            $model->updated_by = auth()->id();
        });
        static::updating(function ($model) {
            $model->updated_by = auth()->id();
        });
    }
}
