<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Payment extends Model
{
    use HasFactory;
    protected $fillable = [
        'transaction_id',
        'order_id',
        'amount',
        'currency',
        'success',
        'transaction_created_at',
        'is_3d_secure',
        'payment_method',
        'card_type',
        'card_last4',
        'receipt_number',
        'customer_email',
        'customer_phone',
        'items',
        'payment_for',
    ];

    protected $casts = [
        'items'                  => 'array',
        'success'                => 'boolean',
        'is_3d_secure'           => 'boolean',
    ];



    public static function getTotalAmountsPaid()
    {
        return Payment::where('success', true)->sum('amount');
    }
}
