<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Facades\Auth;

class Project extends Model
{
    protected $fillable = [
        'user_id',
        'title',
        'description',
        'link',
        'video_link',
        'accepted_by',
        'accepted',
        'comment'
    ];

    protected $casts = [
        'accepted' => 'boolean'
    ];

    public static function boot(){
        parent::boot();
        static::creating(function ($model) {
            $model->accepted_by = Auth::user()->id;
        });
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function acceptedBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'accepted_by');
    }
}
