<?php

namespace App\Models;

use App\Filters\RoundStudentFilters;
use Essa\APIToolKit\Filters\Filterable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RoundStudent extends Model
{
    use HasFactory, Filterable;
    protected string $default_filters = RoundStudentFilters::class;

    protected $fillable = [
        'round_id',
        'user_id',
        'status',
        'total_amount',
        'enrollment_date',
        'payment_method',
        'payment_status',
        'transaction_id',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function round()
    {
        return $this->belongsTo(Round::class);
    }

}
