<?php

namespace App\Models;

use App\Filters\SettingFilters;
use Essa\APIToolKit\Filters\Filterable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;


class Setting extends Model
{
    use HasFactory, Filterable;

    protected string $default_filters = SettingFilters::class;

    /**
     * Mass-assignable attributes.
     *
     * @var array
     */
    protected $fillable = [
        'key',
        'value',
        'category',
        'type',
    ];

    /**
     * Accessor that can access the main image
     */
    public function getValueAttribute()
    {
        $category = $this->attributes['category'] ?? null;
        $value = $this->attributes['value'] ?? null;

        if ($category === 'logos') {
            return $value ? asset('storage/' . $value) : null;
        }

        if (filter_var($value, FILTER_VALIDATE_URL)) {
            return $value;
        }

        return $value;
    }


    public function getValueMobileAttribute()
    {
        $key = $this->attributes['key'] ?? null;
        $category = $this->attributes['category'] ?? null;
        $value = $this->attributes['value'] ?? null;

        if (str_ends_with($key, '_ar') && app()->getLocale() == 'ar') {
            return $value;
        }

        if ($category === 'logos') {
            return $value ? asset('storage/' . $value) : null;
        }

        if (filter_var($value, FILTER_VALIDATE_URL)) {
            return $value;
        }

        return $value;
    }


}
