<?php

namespace App\Models;

use App\Filters\AnswerFilters;
use Essa\APIToolKit\Filters\Filterable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StudentAnswer extends Model
{
    use HasFactory, Filterable;
    protected string $default_filters = AnswerFilters::class;

    protected $fillable = [
        'student_id',
        'lecture_id',
        'question_id',
        'question_type',
        'answer_content',
        'option_id',
        'is_correct'
    ];

    public function student()
    {
        return $this->belongsTo(User::class, 'student_id');
    }

    public function lecture()
    {
        return $this->belongsTo(Lecture::class);
    }

    public function question()
    {
        return $this->belongsTo(LectureQuestion::class, 'question_id');
    }

    public function option()
    {
        return $this->belongsTo(QuestionOption::class, 'option_id');
    }
}
