<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Survey extends Model
{
    protected $fillable = [
        'title',
        'description',
        'slug',
        'logo',
        'settings',
        'status',
        'user_id'
    ];

    protected $casts = [
        'settings' => 'array',
    ];

    public function sections(): HasMany
    {
        return $this->hasMany(SurveySection::class);
    }

    public function answers(): HasMany
    {
        return $this->hasMany(SurveyAnswer::class);
    }
}
