<?php

namespace App\Models;

use App\Filters\TaskSubmissionFilters;
use Essa\APIToolKit\Filters\Filterable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class TaskSubmission extends Model
{
    use HasFactory, Filterable;

    protected string $default_filters = TaskSubmissionFilters::class;

    protected $fillable = [
        'lecture_id',
        'user_id',
        'graded_by',
        'task_url',
        'task_degree',
        'is_corrected',
    ];


    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function lecture(): BelongsTo
    {
        return $this->belongsTo(Lecture::class);
    }

    public function gradedBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'graded_by');
    }

    public function feedbacks()
    {
        return $this->hasMany(TaskFeedback::class);
    }
}
