<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TicketAttachment extends Model
{
    protected $fillable = [
        'ticket_id',
        'user_id',
        'file_path',
    ];

    public function getFilePathAttribute($value){
        return asset('storage/'.$value);
    }

    public function ticket(){
        return $this->belongsTo(TicketSystem::class,'ticket_id');
    }
    public function user(){
        return $this->belongsTo(User::class,'user_id');
    }
}
