<?php

namespace App\Models;

use App\Enums\TicketStatus;
use App\Filters\TicketSystemFilters;
use Essa\APIToolKit\Filters\Filterable;
use Illuminate\Database\Eloquent\Model;

class TicketSystem extends Model
{
    use Filterable;
    protected string $default_filters = TicketSystemFilters::class;
    protected $fillable = [
        'subject',
        'description',
        'status',
        'priority',
        'user_id',
        'assigned_to',
        'assigned_to_by',
        'open_date',
        'close_date'
    ];

    protected $casts = [
        'open_date' => 'datetime',
        'close_date' => 'datetime',
    ];


    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->user_id = auth()->id();
            $model->open_date = now();
        });

        static::updating(function ($model) {
            if ($model->status == TicketStatus::CLOSED->value) {
                $model->close_date = now();
            }
        });
    }


    public function user(){
        return $this->belongsTo(User::class);
    }

    public function assignedTo(){
        return $this->belongsTo(User::class,'assigned_to');
    }
    public function assignedToBy(){
        return $this->belongsTo(User::class,'assigned_to_by');
    }
    public function ticketReplies(){
        return $this->hasMany(TicketReply::class,'ticket_id');
    }
    public function ticketAttachments(){
        return $this->hasMany(TicketAttachment::class,'ticket_id');
    }
}
