<?php

namespace App\Observers;

use App\Models\TaskSubmission;
use Illuminate\Support\Facades\Cache;

class TaskSubmissionObserver
{
    /**
     * Handle the TaskSubmission "created" event.
     */
    public function created(TaskSubmission $taskSubmission): void
    {
        $this->clearStudentProgressCache($taskSubmission->user_id);
    }

    /**
     * Handle the TaskSubmission "updated" event.
     */
    public function updated(TaskSubmission $taskSubmission): void
    {
        $this->clearStudentProgressCache($taskSubmission->user_id);
    }

    /**
     * Handle the TaskSubmission "deleted" event.
     */
    public function deleted(TaskSubmission $taskSubmission): void
    {
        $this->clearStudentProgressCache($taskSubmission->user_id);
    }

    /**
     * Handle the TaskSubmission "restored" event.
     */
    public function restored(TaskSubmission $taskSubmission): void
    {
        //
    }

    /**
     * Handle the TaskSubmission "force deleted" event.
     */
    public function forceDeleted(TaskSubmission $taskSubmission): void
    {
        //
    }

    /**
     * Clear the student progress cache.
     */
    private function clearStudentProgressCache(int $userId): void
    {
        $cacheKey = "student_progress_{$userId}";
        Cache::forget($cacheKey);
    }
}
