<?php

namespace App\Services\Notification;

use App\Models\User;
use App\Models\Round;
use App\Models\Notification;
use App\Models\RoundStudent;
use Illuminate\Support\Facades\DB;

class NotificationService
{
    public function getNotifiedUsers($userIds)
    {
        return User::whereIn('id', $userIds)->get();
    }
    public function storeNotification($data,$notifiables)
    {
        if($notifiables->count() > 0){
            foreach ($notifiables as $notifiable) {
                $notification = new Notification([
                'data'            => $data,
                'notifiable_id'   => $notifiable->id,
                'notifiable_type' => get_class($notifiable),
                'type'            => 'notification',
                'read_at'         => null,
            ]);
            $notification->id = \Illuminate\Support\Str::uuid();
                $notification->save();
            }
        }
    }
    public function storeNotificationSingle($data,$notifiable)
    {
        $notification = new Notification([
                'data'            => $data,
                'notifiable_id'   => $notifiable->id,
                'notifiable_type' => get_class($notifiable),
                'type'            => 'notification',
                'read_at'         => null,
            ]);
            $notification->id = \Illuminate\Support\Str::uuid();
                $notification->save();
    }
    public function getLatestNotifications()
    {
        $user = auth()->user();
        return $user->notifications()->take(3)->get();
    }
    public function getAllUserNotifications()
    {
        $user = auth()->user();
        return $user->notifications()->latest()->dynamicPaginate();
    }
    public function getUnReadNotificationCount()
    {
        $user = auth()->user();
        return $user->notifications()->unread()->count();
    }
    public function readNotification($notificationId)
    {
        $notification = DB::table('notifications')->find($notificationId);
        if ($notification !== null && $notification->read_at === null) {
            DB::table('notifications')->where('id', '=', $notificationId)->update(['read_at' => now()]);
        }
        return $notification;
    }


    public function markAllNotificationsAsRead()
    {
        $user = auth()->user();
        if ($user->unreadNotifications) {
            foreach ($user->unreadNotifications as $notification) {
                $notification->markAsRead();
            }
        }
    }
    public function getNotifiablesByContext($data)
    {
        if(isset($data['round_id'])){
            $userIds = RoundStudent::where('round_id', $data['round_id'])
                ->distinct()
                ->pluck('user_id');
            return User::whereIn('id', $userIds)->get();
        }
        if(isset($data['course_id'])){
            $roundId = Round::where('course_id', $data['course_id'])->first()?->id;
            if (!$roundId) return collect([]);
            $userIds = RoundStudent::where('round_id', $roundId)
                ->distinct()
                ->pluck('user_id');
            return User::whereIn('id', $userIds)->get();
        }
        return collect([]);
    }

}
