<?php

namespace App\Services\Payment;

use Exception;
use Illuminate\Support\Facades\Http;

class BasePaymentService
{

    protected function buildRequest(string $method, string $url, array $headers, array $data = null, string $type = 'json')
    {
        try {
            $response = Http::withHeaders($headers)->send($method, $url, [
                $type => $data
            ]);

            // Return response as JSON
            return response()->json([
                'success' => $response->successful(),
                'status'  => $response->status(),
                'data'    => $response->json(),
            ], $response->status());
        } catch (\Exception $e) {
            // Handle exceptions and return an error response
            return response()->json([
                'success' => false,
                'status'  => 500,
                'message' => $e->getMessage(),
            ], 500);
        }
    }




    public function getAuthToken()
    {
        $url = env('PAYMOB_BASE_URL') . '/api/auth/tokens';
        $response = Http::post($url, [
            'api_key' => env('PAYMOB_API_KEY'),
        ]);
        return $response->json()['token'];
    }
    }

