<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Log Retention Periods
    |--------------------------------------------------------------------------
    |
    | Define how long to keep activity logs before they are automatically deleted.
    | You can specify retention periods in days, months, or years.
    | Set to null to keep logs indefinitely.
    |
    */
    'retention_period' => [
        'days' => env('ACTIVITY_LOG_RETENTION_DAYS', 1), // Keep logs for 30 days by default
    ],

    /*
    |--------------------------------------------------------------------------
    | Log Cleanup Schedule
    |--------------------------------------------------------------------------
    |
    | Define how often the cleanup command should run.
    | Options: daily, weekly, monthly
    |
    */
    'cleanup_schedule' => env('ACTIVITY_LOG_CLEANUP_SCHEDULE', 'daily'),
];
