<?php

namespace Database\Factories;

use App\Models\User;
use App\Models\Course;
use Illuminate\Database\Eloquent\Factories\Factory;


class FeedbackFactory extends Factory
{
    public function definition(): array
    {
        $users   = User::all();
        $courses = Course::all();
        return [
            'user_id'   => $users->random()->id,
            'course_id' => $courses->random()->id,
            'content'   => $this->faker->sentence,
            'rating'    => $this->faker->numberBetween(1, 5),
        ];
    }

}
