<?php

use App\Enums\DefineStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::create('courses', function (Blueprint $table) {
            $table->id();
            $table->foreignId('category_id')->constrained('categories')->onDelete('restrict');
            $table->string('title')->index();
            $table->string('image');
            $table->decimal('price', 8, 2)->default(0.00);
            $table->text('description');
            $table->integer('sessions_count');
            $table->integer('duration');
            $table->json('what_you_will_learn');
            $table->string('learning_plan');
            $table->unsignedTinyInteger('status')->default(DefineStatus::default())->index();
            $table->timestamps();
        });
    }   

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        Schema::dropIfExists('courses');
    }
};
