<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('ticket_systems', function (Blueprint $table) {
            $table->timestamp('open_date')->nullable()->after('assigned_to_by');
            $table->timestamp('close_date')->nullable()->after('open_date');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('ticket_systems', function (Blueprint $table) {
            $table->dropColumn(['open_date', 'close_date']);
        });
    }
};
